<?php

class ControllerExtensionFeedMergadoMarketingPack extends Controller {

  const VERSION = '1.0.0';
  const LOGO_URL = 'view/image/mergado/logo.svg';
  const CSS_URL = 'view/stylesheet/mergado_marketing_pack.css';
  const JS_URL = 'view/javascript/mergado_marketing_pack.js';

  private $extension_path = 'feed/';
  private $extension_name = 'mergado_marketing_pack'; 
  private $extension_fullname = 'feed_mergado_marketing_pack';
  private $extension_type = 'feed';
  private $error = array();
  private $stores = array();
  private $currentLang;

  public function index() {

    $this->currentLang = $this->language->get('code'); 

    //load translations
    $this->load->language('extension/' . $this->extension_path . $this->extension_name);

    //localization
    $this->document->setTitle($this->language->get('heading_title'));
    $this->document->addScript(self::JS_URL);
    $this->document->addStyle(self::CSS_URL);

    //load models
    $this->load->model('setting/setting');
    $this->load->model('localisation/language');
    $this->load->model('localisation/currency');
    $this->load->model('extension/'. $this->extension_path . $this->extension_name);
    $this->load->model('extension/'. $this->extension_path . $this->extension_name . '_logger');
    $this->load->model('extension/'. $this->extension_path . $this->extension_name . '_generator');

    $model_name = "model_extension_" . $this->extension_type . "_" . $this->extension_name;
    $model_logger = "model_extension_" . $this->extension_type . "_" . $this->extension_name . '_logger';
    $model_generator = "model_extension_" . $this->extension_type . "_" . $this->extension_name . '_generator';
    
    //get all stores
    $data['stores'] = $this->getStores();

    //get all languages
    $data['languages'] = $this->model_localisation_language->getLanguages();

    //get all currencies
    $data['currencies'] = $this->model_localisation_currency->getCurrencies();

    //process data
    if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate() ) {
      $this->model_setting_setting->editSetting($this->extension_fullname, $this->request->post);
          
      $this->session->data['success'] = $this->language->get('text_success');
          
      $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=' . $this->extension_type, true));
    }

    //settings
    $settings = $this->model_setting_setting->getSetting($this->extension_fullname);
    if (!empty($settings)) {
      foreach($settings as $key=>$value) {
        if (!isset($data[$key])) {
          $data[$key] = $value;
        }
      }
    }

    //set logger
    define('MERGADO_LOGGER_ENABLED', (int) $this->config->get($this->extension_fullname . '_logs'));

    //set warnings
    if (isset($this->error['warning'])) {
      $data['error_warning'] = $this->error['warning'];
    } else {
      $data['error_warning'] = '';
    }

    //breadcrumbs menu
    $data['breadcrumbs'] = array();

    $data['breadcrumbs'][] = array(
      'text' => $this->language->get('text_home'),
      'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
    );

    $data['breadcrumbs'][] = array(
      'text' => $this->language->get('text_extension'),
      'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=' . $this->extension_type, true)
    );

    $data['breadcrumbs'][] = array(
      'text' => $this->language->get('heading_title'),
      'href' => $this->url->link('extension/' . $this->extension_path . $this->extension_name, 'user_token=' . $this->session->data['user_token'], true)
    );

    //data for view
    $data['action'] = $this->url->link('extension/' . $this->extension_path . $this->extension_name, 'user_token=' . $this->session->data['user_token'], true);
    $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=' . $this->extension_type, true);
    
    $data['user_token'] = $this->session->data['user_token'];
    $data['route'] = 'extension/' . $this->extension_path . $this->extension_name;
    $data['extension_fullname'] = $this->extension_fullname;
    $data['tab_name'] = isset($this->request->get['tab']) ? $this->request->get['tab'] : '';

    //form data
    if (!empty($this->request->post)) {
      foreach($this->request->post as $key=>$value) {
        $data[$key] = $value;
      }
    }

    if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$data['base_url'] = HTTPS_SERVER;
		} else {
			$data['base_url'] = HTTP_SERVER;
    }
    
    $data['product_feeds'] = array();
    $data['store_logs'] = array();
    $mergado_token = $this->{$model_name}->getMergadoToken();
    foreach($data['stores']  as $store) {
      
      //store logs
      $log_hash = md5($mergado_token . '_log_' . $store['store_id']);
      $data['store_logs'][$store['store_id']] = array(
        'hash' => $log_hash
      );

      foreach($data['languages'] as $lang) {
        foreach($data['currencies'] as $currency) {
          $currency_code = strtolower($currency['code']);
          $hash = md5('pf_' . $store['store_id'] . '_' . $lang['code'] . '_' . $currency_code);
          $cron_hash = md5($mergado_token . '_pf_' . $store['store_id'] . '_' . $lang['code'] . '_' . $currency_code);

          $path = $data['stores'][0]['url'] . 'mergado/pf_' . $hash . '.xml';

          $status = '-';
          $last_change = '-';
          if($result = $this->{$model_generator}->getData($hash)) {
            $status = isset($result[0]['status']) && $result[0]['status'] == 1 ? $result[0]['status'] : '-';
            $last_change = isset($result[0]['change_date']) && $this->currentLang == 'en' ? date('Y.m.d H:i:s', strtotime($result[0]['change_date'])) : date('d.m.Y H:i:s', strtotime($result[0]['change_date']));
          }
          
          //product feeds
          $data['product_feeds'][$store['store_id']][$lang['code']][$currency_code] = array(
              'path' => $path,
              'hash' => $hash,
              'cron_hash' => $cron_hash,
              'log_hash' => $log_hash,
              'exists' => $this->urlExists($path) ? 1 : 0,
              'status' => $status,
              'last_change' => $last_change
          );
        }
      }
    }
 
    $data['mergado_token'] = $this->{$model_name}->getMergadoToken();
    $data['version'] = self::VERSION;
    $data['php_version'] = phpversion();
    $data['opencart_version'] = VERSION;
    $data['logo_url'] = $data['base_url'] . self::LOGO_URL;

    $data['header'] = $this->load->controller('common/header');
    $data['column_left'] = $this->load->controller('common/column_left');
    $data['footer'] = $this->load->controller('common/footer');

    //render view
    $this->response->setOutput($this->load->view('extension/' . $this->extension_path . $this->extension_name, $data));
 
  }
  
  protected function validate() {
  
    //check permissions
    if (!$this->user->hasPermission('modify', 'extension/' . $this->extension_path . $this->extension_name)) {
      $this->error['warning'] = $this->language->get('error_permission');
      return !$this->error;
    }

    foreach ($this->stores as $store) {
      //loop
    } 

    return !$this->error;
  }

  public function install() {

    //load models
    $this->load->model('setting/setting');
    $this->load->model("extension/". $this->extension_path . $this->extension_name);

    //enable logging
    $this->model_setting_setting->editSetting($this->extension_fullname, array($this->extension_fullname . '_logs' => 1 ) );

    //create db scheme
    $model_name = "model_extension_" . $this->extension_type . "_" . $this->extension_name;
    $this->{$model_name}->createDBSchema();

  }

  public function uninstall() {

    //load models
    $this->load->model('setting/setting');
    $this->load->model("extension/". $this->extension_path . $this->extension_name);
 
    //delete db scheme
    $model_name = "model_extension_" . $this->extension_type . "_" . $this->extension_name;
    $this->{$model_name}->deleteDBSchema();

    //delete feed files
    $this->deleteFeedFiles();

    //delete module settings
    $this->model_setting_setting->deleteSetting($this->extension_fullname);

  }

  private function deleteFeedFiles() {
    
    $root_dir = DIR_APPLICATION.'../mergado/';
    if(file_exists($root_dir)) {
      $files = scandir($root_dir);

      //delete all .xml files
      array_map('unlink', glob( $root_dir . "*.xml"));

      //delete dir
      rmdir($root_dir);
    }
  }

  public function clearAllLogs() {

    $this->load->model('extension/'. $this->extension_path . $this->extension_name . '_logger');
    $model_logger = "model_extension_" . $this->extension_type . "_" . $this->extension_name . '_logger';

    $this->{$model_logger}->clearAll();
  }

  public function exportCsvLogs() {

    $this->load->model('extension/'. $this->extension_path . $this->extension_name . '_logger');
    $model_logger = "model_extension_" . $this->extension_type . "_" . $this->extension_name . '_logger';

    header('Content-Type: text/plain');
		header('Content-Disposition: attachment;filename="'.date('Y_m_d') .'_mergado_log.csv"');
    header('Cache-Control: max-age=0');
    
    $this->{$model_logger}->exportCSV();
  }

  private function getStores() {

    //load model
    $this->load->model('setting/store');

    //get stores
    $stores = $this->model_setting_store->getStores();

    $this->stores[] = array( //default store
      'store_id' => 0,
      'name'     => $this->config->get('config_name'),
      'url'      => isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1')) ? HTTPS_CATALOG : HTTP_CATALOG
    );
    
    foreach ($stores as $store) {
      $this->stores[] = array(
        'store_id' => $store['store_id'],
        'name'     => $store['name'],
        'url'      => $store['url']
      );
    }

    return $this->stores;

  }

  private function urlExists($url) {
      $headers = get_headers($url);
      return stripos($headers[0], "200 OK" ) ? true : false;
  }

}
