<?php

class ModelExtensionFeedMergadoMarketingPack extends Model {

  const DB_LOG_TABLE = 'mergado_marketing_pack_log';
  const DB_GENERATOR_TABLE = 'mergado_marketing_pack_generator';

  public function createDBSchema() {
  
    //create log table
    $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . SELF::DB_LOG_TABLE . "` (
      `log_id` INT(11) NOT NULL AUTO_INCREMENT,
      `store_id` INT(11) NOT NULL,
      `lang_code` VARCHAR(6) NOT NULL,
      `currency` VARCHAR(3) NOT NULL,
      `log_date` DATETIME NOT NULL,
      `log_label` VARCHAR(255) NOT NULL,
      `log_msg` TEXT NOT NULL,
      PRIMARY KEY (`log_id`)
    ) ENGINE=MyISAM DEFAULT COLLATE=utf8_general_ci");

    //create generator table
    $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . SELF::DB_GENERATOR_TABLE . "` (
      `record_id` INT(11) NOT NULL AUTO_INCREMENT,
      `hash_code` varchar(255) NOT NULL,
      `change_date` DATETIME NOT NULL,
      `status` INT NOT NULL,
      PRIMARY KEY (`record_id`)
    ) ENGINE=MyISAM DEFAULT COLLATE=utf8_general_ci");

  }

  public function deleteDBSchema(){

    //drop log table
    $this->db->query("DROP TABLE IF EXISTS `" . DB_PREFIX . SELF::DB_LOG_TABLE ."`");

    //drop generator table
    $this->db->query("DROP TABLE IF EXISTS `" . DB_PREFIX . SELF::DB_GENERATOR_TABLE ."`");

  }

  public function getMergadoToken() {
    return substr( sha1($_SERVER['SERVER_NAME']. '$@/digital-wolf-645787'), 0, 30);
  }

}
